import{Clock,Color,Matrix4,Mesh,RepeatWrapping,ShaderMaterial,TextureLoader,UniformsLib,UniformsUtils,Vector2,Vector4}from"three";import{Reflector}from"../objects/Reflector.js";import{Refractor}from"../objects/Refractor.js";class Water extends Mesh{constructor(t,e={}){super(t),this.isWater=1,this.type="Water";const r=this,o=void 0!==e.color?new Color(e.color):new Color(16777215),n=void 0!==e.textureWidth?e.textureWidth:512,a=void 0!==e.textureHeight?e.textureHeight:512,i=void 0!==e.clipBias?e.clipBias:0,l=void 0!==e.flowDirection?e.flowDirection:new Vector2(1,0),f=void 0!==e.flowSpeed?e.flowSpeed:.03,c=void 0!==e.reflectivity?e.reflectivity:.02,m=void 0!==e.scale?e.scale:1,v=void 0!==e.shader?e.shader:Water.WaterShader,u=new TextureLoader,s=e.flowMap||void 0,p=e.normalMap0||u.load("textures/water/Water_1_M_Normal.jpg"),d=e.normalMap1||u.load("textures/water/Water_2_M_Normal.jpg"),x=.15,g=.075,h=new Matrix4,w=new Clock;if(void 0===Reflector)return;if(void 0===Refractor)return;const y=new Reflector(t,{textureWidth:n,textureHeight:a,clipBias:i}),M=new Refractor(t,{textureWidth:n,textureHeight:a,clipBias:i});y.matrixAutoUpdate=0,M.matrixAutoUpdate=0,this.material=new ShaderMaterial({name:v.name,uniforms:UniformsUtils.merge([UniformsLib.fog,v.uniforms]),vertexShader:v.vertexShader,fragmentShader:v.fragmentShader,transparent:1,fog:1}),void 0!==s?(this.material.defines.USE_FLOWMAP="",this.material.uniforms.tFlowMap={type:"t",value:s}):this.material.uniforms.flowDirection={type:"v2",value:l},p.wrapS=p.wrapT=RepeatWrapping,d.wrapS=d.wrapT=RepeatWrapping,this.material.uniforms.tReflectionMap.value=y.getRenderTarget().texture,this.material.uniforms.tRefractionMap.value=M.getRenderTarget().texture,this.material.uniforms.tNormalMap0.value=p,this.material.uniforms.tNormalMap1.value=d,this.material.uniforms.color.value=o,this.material.uniforms.reflectivity.value=c,this.material.uniforms.textureMatrix.value=h,this.material.uniforms.config.value.x=0,this.material.uniforms.config.value.y=g,this.material.uniforms.config.value.z=g,this.material.uniforms.config.value.w=m,this.onBeforeRender=function(t,e,o){!function(t){h.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),h.multiply(t.projectionMatrix),h.multiply(t.matrixWorldInverse),h.multiply(r.matrixWorld)}(o),function(){const t=w.getDelta(),e=r.material.uniforms.config;e.value.x+=f*t,e.value.y=e.value.x+g,e.value.x>=x?(e.value.x=0,e.value.y=g):e.value.y>=x&&(e.value.y=e.value.y-x)}(),r.visible=0,y.matrixWorld.copy(r.matrixWorld),M.matrixWorld.copy(r.matrixWorld),y.onBeforeRender(t,e,o),M.onBeforeRender(t,e,o),r.visible=1}}}Water.WaterShader={name:"WaterShader",uniforms:{color:{type:"c",value:null},reflectivity:{type:"f",value:0},tReflectionMap:{type:"t",value:null},tRefractionMap:{type:"t",value:null},tNormalMap0:{type:"t",value:null},tNormalMap1:{type:"t",value:null},textureMatrix:{type:"m4",value:null},config:{type:"v4",value:new Vector4}},vertexShader:"\n\n\t\t#include <common>\n\t\t#include <fog_pars_vertex>\n\t\t#include <logdepthbuf_pars_vertex>\n\n\t\tuniform mat4 textureMatrix;\n\n\t\tvarying vec4 vCoord;\n\t\tvarying vec2 vUv;\n\t\tvarying vec3 vToEye;\n\n\t\tvoid main() {\n\n\t\t\tvUv = uv;\n\t\t\tvCoord = textureMatrix * vec4( position, 1.0 );\n\n\t\t\tvec4 worldPosition = modelMatrix * vec4( position, 1.0 );\n\t\t\tvToEye = cameraPosition - worldPosition.xyz;\n\n\t\t\tvec4 mvPosition =  viewMatrix * worldPosition; // used in fog_vertex\n\t\t\tgl_Position = projectionMatrix * mvPosition;\n\n\t\t\t#include <logdepthbuf_vertex>\n\t\t\t#include <fog_vertex>\n\n\t\t}",fragmentShader:"\n\n\t\t#include <common>\n\t\t#include <fog_pars_fragment>\n\t\t#include <logdepthbuf_pars_fragment>\n\n\t\tuniform sampler2D tReflectionMap;\n\t\tuniform sampler2D tRefractionMap;\n\t\tuniform sampler2D tNormalMap0;\n\t\tuniform sampler2D tNormalMap1;\n\n\t\t#ifdef USE_FLOWMAP\n\t\t\tuniform sampler2D tFlowMap;\n\t\t#else\n\t\t\tuniform vec2 flowDirection;\n\t\t#endif\n\n\t\tuniform vec3 color;\n\t\tuniform float reflectivity;\n\t\tuniform vec4 config;\n\n\t\tvarying vec4 vCoord;\n\t\tvarying vec2 vUv;\n\t\tvarying vec3 vToEye;\n\n\t\tvoid main() {\n\n\t\t\t#include <logdepthbuf_fragment>\n\n\t\t\tfloat flowMapOffset0 = config.x;\n\t\t\tfloat flowMapOffset1 = config.y;\n\t\t\tfloat halfCycle = config.z;\n\t\t\tfloat scale = config.w;\n\n\t\t\tvec3 toEye = normalize( vToEye );\n\n\t\t\t// determine flow direction\n\t\t\tvec2 flow;\n\t\t\t#ifdef USE_FLOWMAP\n\t\t\t\tflow = texture2D( tFlowMap, vUv ).rg * 2.0 - 1.0;\n\t\t\t#else\n\t\t\t\tflow = flowDirection;\n\t\t\t#endif\n\t\t\tflow.x *= - 1.0;\n\n\t\t\t// sample normal maps (distort uvs with flowdata)\n\t\t\tvec4 normalColor0 = texture2D( tNormalMap0, ( vUv * scale ) + flow * flowMapOffset0 );\n\t\t\tvec4 normalColor1 = texture2D( tNormalMap1, ( vUv * scale ) + flow * flowMapOffset1 );\n\n\t\t\t// linear interpolate to get the final normal color\n\t\t\tfloat flowLerp = abs( halfCycle - flowMapOffset0 ) / halfCycle;\n\t\t\tvec4 normalColor = mix( normalColor0, normalColor1, flowLerp );\n\n\t\t\t// calculate normal vector\n\t\t\tvec3 normal = normalize( vec3( normalColor.r * 2.0 - 1.0, normalColor.b,  normalColor.g * 2.0 - 1.0 ) );\n\n\t\t\t// calculate the fresnel term to blend reflection and refraction maps\n\t\t\tfloat theta = max( dot( toEye, normal ), 0.0 );\n\t\t\tfloat reflectance = reflectivity + ( 1.0 - reflectivity ) * pow( ( 1.0 - theta ), 5.0 );\n\n\t\t\t// calculate final uv coords\n\t\t\tvec3 coord = vCoord.xyz / vCoord.w;\n\t\t\tvec2 uv = coord.xy + coord.z * normal.xz * 0.05;\n\n\t\t\tvec4 reflectColor = texture2D( tReflectionMap, vec2( 1.0 - uv.x, uv.y ) );\n\t\t\tvec4 refractColor = texture2D( tRefractionMap, uv );\n\n\t\t\t// multiply water color with the mix of both textures\n\t\t\tgl_FragColor = vec4( color, 1.0 ) * mix( refractColor, reflectColor, reflectance );\n\n\t\t\t#include <tonemapping_fragment>\n\t\t\t#include <colorspace_fragment>\n\t\t\t#include <fog_fragment>\n\n\t\t}"};export{Water};